<?php

use ConnectAPI\Point;
?>
<h2>Punkty za zakupy</h2>
<h5>Przekazanie punktów w programie</h5>
<ol class="breadcrumb pb-4">
  <li class="breadcrumb-item"><a href="index.php">Programy</a></li>
  <li class="breadcrumb-item"><a href="index.php?program=<?= $program->id ?>"><?= $program->name ?></a></li>
  <li class="breadcrumb-item active">Punkty za zakupy</li>
</ol>

<div class="row justify-content-center">
  <div class="col col-md-8 col-lg-6">
    <form action="points.php">
      <input type="hidden" name="program" value="<?= $program->id ?>" />
      <input type="hidden" name="tag" value="<?= $point->tag ?>" />
      <div class="card">
        <div class="card-header">
          <h5>Przekazujesz klientowi punkty za zakupy</h5>
        </div>
        <div class="card-body">
          <? if (isset($error)): ?>
          <div class="alert alert-danger d-flex">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-exclamation-triangle-fill flex-shrink-0 me-2" viewBox="0 0 16 16" role="img">
              <path d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z"/>
            </svg>  
            <div><?= $error ?></div>
          </div>
          <? endif; ?>
          <p>Zakup: <b><?= $point->name ?></b> (<?= $point->label ?>)</p>
          <p>
            <div class="form-floating">
              <input class="form-control" type="text" name="number" id="number"
                    placeholder="Liczba całkowita" maxlength="5"
                    oninput="this.value = this.value.replace(/[^0-9]/g, '')" />
              <label for="number">
                <?= $point->type == Point::TypeAmount ? 'Podaj kwotę zakupów' : 'Podaj liczbę sztuk' ?>
              </label>
            </div>
          </p>
        </div>
        <div class="card-footer text-end pt-3 pb-3">
          <button class="btn btn-primary" type="submit">Przekaż punkty &raquo;</button>
        </div>
      </div>
    </form>
  </div>
</div>
