<?php
$currentDir = dirname(__FILE__);
require_once "{$currentDir}/login.php";

$code = filter_input(INPUT_GET, 'code', FILTER_SANITIZE_NUMBER_INT);
$view = 'prize';

if ($code) { // podany kod odbioru nagrody
  $result = $client->checkCode($code);
  if ($client->error()) { // problem z kodem nagrody
    $error = $client->error();
  }
  else { // kod odbioru prawidlowy
    if (filter_input(INPUT_GET, 'confirm', FILTER_SANITIZE_NUMBER_INT)) {
      // odbior nagrody
      $confirm = $client->confirmCode($code);
      if ($client->error())
        $error = $client->error();
      else {
        $view = 'result';
        $result = $confirm;
      }
    }
    else {
      // odbior jeszcze nie potwierdzony
      $view = 'confirm';
    }
  }
}

if ($view == 'confirm')
  $program = $client->program($result->programId);

// wywolanie widoku
//
ob_start();
include "{$currentDir}/view.{$view}.php";
$page = ob_get_clean();
include "{$currentDir}/view.layout.php";
