<?php
use ConnectAPI\Point;

$currentDir = dirname(__FILE__);
require_once "{$currentDir}/login.php";

$programId = filter_input(INPUT_GET, 'program', FILTER_SANITIZE_NUMBER_INT);
$tag = filter_input(INPUT_GET, 'tag');

$programId && $tag
or die('Nieprawidłowe parametry');

// pobranie informacji o programie
//
$program = $client->program($programId)
or die ($client->error());

// pobranie definicji punktow za zakupy
//
$point = $client->point($programId, $tag);
if ($client->error())
  die($client->error());

// nie znaleziono definicji punktow
//
$point
or die('Nie odnaleziono definicji punktów za zakupy');

// sprawdzenie, czy podano juz liczbe lub kwote zakupow w formularzu
$number = filter_input(INPUT_GET, 'number', FILTER_SANITIZE_NUMBER_INT);
if (!$number) { // wyswietl formularz parametrow punktow
  $view = 'points';
}
else { // juz podano liczbe lub kwote, generujemy punkty
  // sprawdzamy, czy wystarczajaca kwota
  if ($point->type == Point::TypeAmount && $number < $point->amount) {
    $error = "Do naliczenia punktów kwota zakupów musi wynosić co najmniej {$point->amount}";
    $view = 'points';
  }
  else {
    $code = $client->givePoints($programId, $tag, $number);
    if ($client->error()) die($client->error());
    $view = 'code';
  }
}

// wywolanie widoku
//
ob_start();
include "{$currentDir}/view.{$view}.php";
$page = ob_get_clean();
include "{$currentDir}/view.layout.php";
